unit main;

interface

uses
  SysUtils, Variants, Classes, Controls, QForms,
  QDialogs, DBXpress, DB, SqlExpr, FMTBcd, QStdCtrls, DBClient, Provider,
  QDBCtrls, QGrids, QDBGrids, QExtCtrls;

type
  TfBlobSample = class(TForm)
    Test_BlobConnection: TSQLConnection;
    SQLQuery1: TSQLQuery;
    SQLDataSet1: TSQLDataSet;
    DataSetProvider1: TDataSetProvider;
    ClientDataSet1: TClientDataSet;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    DBMemo1: TDBMemo;
    DBImage1: TDBImage;
    Panel1: TPanel;
    btnCreateTable: TButton;
    btnDropDB: TButton;
    btnCreateDB: TButton;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Splitter1: TSplitter;
    Splitter2: TSplitter;
    Splitter3: TSplitter;
    SQLQuery2: TSQLQuery;
    Button4: TButton;
    btnDroopTable: TButton;
    MasterConnection: TSQLConnection;
    SQLQuery3: TSQLQuery;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure btnCreateDBClick(Sender: TObject);
    procedure btnDropDBClick(Sender: TObject);
    procedure btnCreateTableClick(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure btnDroopTableClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fBlobSample: TfBlobSample;

implementation

{$R *.dfm}

procedure TfBlobSample.Button1Click(Sender: TObject);
begin
  try
    SQLQuery1.SQL.Clear;
    SQLQuery1.SQL.Add('use test_blob');
    SQLQuery1.SQL.Add('insert into test_blob values(:a,:b)');
    SQLQuery1.Params.ParamByName('a').LoadFromFile('licence.txt',ftMemo);
    SQLQuery1.Params.ParamByName('b').LoadFromFile('visoco.bmp',ftGraphic);
    SQLQuery1.ExecSQL();
    ShowMessage('Insert is executed successfully.');
  except
    on E: Exception do ShowMessage(E.Message);
  end;
end;

procedure TfBlobSample.Button2Click(Sender: TObject);
begin
  ClientDataSet1.Close;
  ClientDataSet1.Open;
end;

procedure TfBlobSample.btnCreateDBClick(Sender: TObject);
begin
  try
    SQLQuery3.SQL.Clear;
    SQLQuery3.SQL.Add('create database test_blob');
    SQLQuery3.ExecSQL();
    ShowMessage('DataBase created successfully.');
  except
    on E: Exception do ShowMessage(E.Message);
  end;
end;

procedure TfBlobSample.btnDropDBClick(Sender: TObject);
begin
  try
    ClientDataSet1.Close;
    SQLDataSet1.Close;
    Test_BlobConnection.Close;
    MasterConnection.Close;
    SQLQuery3.SQL.Clear;
    SQLQuery3.SQL.Add('use master');
    SQLQuery3.SQL.Add('drop database test_blob');
    SQLQuery3.ExecSQL();
    ShowMessage('DataBase deleted successfully.');
  except
    on E: Exception do ShowMessage(E.Message);
  end;
end;

procedure TfBlobSample.btnCreateTableClick(Sender: TObject);
begin
  try
    // SQL command create table
    SQLQuery3.SQL.Clear;
    SQLQuery3.SQL.Add('use test_blob');
    SQLQuery3.SQL.Add('create table test_blob(id numeric identity, ctext text, cimage image)');
    SQLQuery3.ExecSQL();
    ShowMessage('Table created successfully.');
  except
    on E: Exception do ShowMessage(E.Message);
  end;

end;

procedure TfBlobSample.Button3Click(Sender: TObject);
begin
  try
    SQLQuery1.SQL.Clear;
    SQLQuery1.SQL.Add('use test_blob');
    SQLQuery1.SQL.Add('insert into test_blob values(:a,:b)');
    SQLQuery1.Params.ParamByName('a').LoadFromFile('readme.txt',ftMemo);
    SQLQuery1.Params.ParamByName('b').LoadFromFile('visoco1.bmp',ftGraphic);
    SQLQuery1.ExecSQL();
    ShowMessage('Insert executed successfully.');
  except
    on E: Exception do ShowMessage(E.Message);
  end;
end;

procedure TfBlobSample.Button4Click(Sender: TObject);
begin
SQLQuery2.Close;
SQLQuery2.ParamByName('a').AsInteger := ClientDataSet1.FieldByName('id').AsInteger;
SQLQuery2.Open;
TBlobField(SQLQuery2.FieldByName('ctext')).SaveToFile('output.txt');
TBlobField(SQLQuery2.FieldByName('cimage')).SaveToFile('output.bmp');
end;

procedure TfBlobSample.btnDroopTableClick(Sender: TObject);
begin
  try
    // SQL command drop table
    SQLQuery3.SQL.Clear;
    SQLQuery3.SQL.Add('use test_blob');
    SQLQuery3.SQL.Add('drop table test_blob');
    SQLQuery3.ExecSQL();
    ShowMessage('Table dropped successfully.');
  except
    on E: Exception do ShowMessage(E.Message);
  end;
end;

end.


